/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.complex;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.floats.FloatUtils;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.CanBeDoubleNode;
import com.oracle.graal.python.lib.PyComplexCheckExactNode;
import com.oracle.graal.python.lib.PyComplexCheckNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatCheckNode;
import com.oracle.graal.python.lib.PyLongAsDoubleNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.truffle.PythonIntegerAndFloatTypes;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.ComplexFormatter;
import com.oracle.graal.python.runtime.formatting.FormattingUtils;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PComplex})
public final class ComplexBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ComplexBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ComplexBuiltinsFactory.getFactories();
    }

    @Builtin(name="conjugate", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ConjugateNode
    extends PythonUnaryBuiltinNode {
        ConjugateNode() {
        }

        @Specialization
        static PComplex hash(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Bind PythonLanguage language) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return PFactory.createComplex(language, c.getReal(), -c.getImag());
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long doPComplex(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode) {
            long imagHash;
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            long realHash = PyObjectHashNode.hash(c.getReal());
            long combined = realHash + 1000003L * (imagHash = PyObjectHashNode.hash(c.getImag()));
            return combined == -1L ? -2L : combined;
        }
    }

    @Builtin(name="imag", minNumOfPositionalArgs=1, isGetter=true, doc="the imaginary part of a complex number")
    @GenerateNodeFactory
    static abstract class ImagNode
    extends PythonBuiltinNode {
        ImagNode() {
        }

        @Specialization
        static double get(PComplex self) {
            return self.getImag();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static double getNative(PythonAbstractNativeObject self, @Cached CStructAccess.ReadDoubleNode read) {
            return read.readFromObj(self, CFields.PyComplexObject__cval__imag);
        }
    }

    @Builtin(name="real", minNumOfPositionalArgs=1, isGetter=true, doc="the real part of a complex number")
    @GenerateNodeFactory
    static abstract class RealNode
    extends PythonBuiltinNode {
        RealNode() {
        }

        @Specialization
        static double get(PComplex self) {
            return self.getReal();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static double getNative(PythonAbstractNativeObject self, @Cached CStructAccess.ReadDoubleNode read) {
            return read.readFromObj(self, CFields.PyComplexObject__cval__real);
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetNewArgsNode
    extends PythonUnaryBuiltinNode {
        GetNewArgsNode() {
        }

        @Specialization
        static PTuple get(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Bind PythonLanguage language) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return PFactory.createTuple(language, new Object[]{c.getReal(), c.getImag()});
        }
    }

    @Slot(value=Slot.SlotKind.nb_positive, isComplex=true)
    @GenerateNodeFactory
    static abstract class PosNode
    extends PythonUnaryBuiltinNode {
        PosNode() {
        }

        @Specialization
        static PComplex pos(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Bind PythonLanguage language) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return PFactory.createComplex(language, c.getReal(), c.getImag());
        }
    }

    @Slot(value=Slot.SlotKind.nb_negative, isComplex=true)
    @GenerateNodeFactory
    static abstract class NegNode
    extends PythonUnaryBuiltinNode {
        NegNode() {
        }

        @Specialization
        static PComplex neg(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Bind PythonLanguage language) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return PFactory.createComplex(language, -c.getReal(), -c.getImag());
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        BoolNode() {
        }

        @Specialization
        static boolean bool(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return c.getReal() != 0.0 || c.getImag() != 0.0;
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ComplexBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static TruffleString format(Object self, TruffleString formatString, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PRaiseNode raiseNode) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            InternalFormat.Spec spec = InternalFormat.fromText(formatString, '\uffff', '>', inliningTarget);
            FormatNode.validateSpec(inliningTarget, spec, raiseNode);
            return FormatNode.doFormat(inliningTarget, c.getReal(), c.getImag(), spec);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString doFormat(Node raisingNode, double real, double imag, InternalFormat.Spec spec) {
            ComplexFormatter formatter = new ComplexFormatter(FormattingUtils.validateForFloat(spec, "complex", raisingNode), raisingNode);
            formatter.format(real, imag);
            return formatter.pad().getResult();
        }

        private static void validateSpec(Node inliningTarget, InternalFormat.Spec spec, PRaiseNode raiseNode) {
            if (spec.getFill(' ') == '0') {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ZERO_PADDING_NOT_ALLOWED_FOR_COMPLEX_FMT);
            }
            char align = spec.getAlign('>');
            if (align == '=') {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.S_ALIGNMENT_FLAG_NOT_ALLOWED_FOR_COMPLEX_FMT, Character.valueOf(align));
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static TruffleString repr(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return ReprNode.doFormat(inliningTarget, c.getReal(), c.getImag());
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString doFormat(Node inliningTarget, double real, double imag) {
            ComplexFormatter formatter = new ComplexFormatter(new InternalFormat.Spec(-1, '\uffff'), inliningTarget);
            formatter.format(real, imag);
            return formatter.pad().getResult();
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare)
    @GenerateNodeFactory
    @GenerateUncached
    static abstract class ComplexRichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        ComplexRichCmpNode() {
        }

        @Specialization
        static Object doComplex(Object left, Object right, RichCmpOp op, @Bind Node inliningTarget, @Cached ComplexEqNode complexEqNode, @Cached InlinedConditionProfile isNotImplementedProfile) {
            if (!op.isEqOrNe()) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            Object result = complexEqNode.execute(inliningTarget, left, right);
            if (isNotImplementedProfile.profile(inliningTarget, result == PNotImplemented.NOT_IMPLEMENTED)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return (Boolean)result == (op == RichCmpOp.Py_EQ);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    static abstract class ComplexEqNode
    extends Node {
        ComplexEqNode() {
        }

        public abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization
        static Object doComplex(PComplex left, PComplex right) {
            return left.getReal() == right.getReal() && left.getImag() == right.getImag();
        }

        @Specialization(guards={"check.execute(inliningTarget, rightObj)"}, limit="1")
        static Object doComplex(Node inliningTarget, Object leftObj, Object rightObj, @Cached PyComplexCheckNode check, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft, @Cached.Exclusive @Cached ToComplexValueNode toComplexRight) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            return left.getReal() == right.getReal() && left.getImag() == right.getImag();
        }

        @Specialization
        static boolean doComplexDouble(Node inliningTarget, Object leftObj, double right, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            return left.getImag() == 0.0 && left.getReal() == right;
        }

        @Specialization
        static boolean doComplexInt(Node inliningTarget, Object leftObj, long right, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft, @Cached InlinedConditionProfile longFitsToDoubleProfile) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            return left.getImag() == 0.0 && FloatBuiltins.ComparisonHelperNode.compareDoubleToLong(inliningTarget, left.getReal(), right, longFitsToDoubleProfile) == 0.0;
        }

        @Specialization
        static boolean doComplexInt(Node inliningTarget, Object leftObj, PInt right, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            return left.getImag() == 0.0 && FloatBuiltins.ComparisonHelperNode.compareDoubleToLargeInt(left.getReal(), right) == 0.0;
        }

        @Fallback
        static PNotImplemented doNotImplemented(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.nb_power, isComplex=true)
    @GenerateNodeFactory
    static abstract class PowerNode
    extends PythonTernaryBuiltinNode {
        PowerNode() {
        }

        @Specialization
        static Object doGeneric(Object leftObj, Object rightObj, PNone mod, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Cached InlinedBranchProfile rightZeroProfile, @Cached InlinedBranchProfile leftZeroProfile, @Cached InlinedBranchProfile smallPositiveProfile, @Cached InlinedBranchProfile smallNegativeProfile, @Cached InlinedBranchProfile complexProfile, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            PComplex result;
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            if (right.getReal() == 0.0 && right.getImag() == 0.0) {
                rightZeroProfile.enter(inliningTarget);
                result = PFactory.createComplex(language, 1.0, 0.0);
            } else if (left.getReal() == 0.0 && left.getImag() == 0.0) {
                leftZeroProfile.enter(inliningTarget);
                if (right.getImag() != 0.0 || right.getReal() < 0.0) {
                    throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.COMPLEX_ZERO_TO_NEGATIVE_POWER);
                }
                result = PFactory.createComplex(language, 0.0, 0.0);
            } else if (right.getImag() == 0.0 && right.getReal() == (double)((int)right.getReal()) && right.getReal() < 100.0 && right.getReal() > -100.0) {
                if (right.getReal() >= 0.0) {
                    smallPositiveProfile.enter(inliningTarget);
                    result = PowerNode.complexToSmallPositiveIntPower(left, (int)right.getReal(), language);
                } else {
                    smallNegativeProfile.enter(inliningTarget);
                    result = DivNode.doubleDivComplex(1.0, PowerNode.complexToSmallPositiveIntPower(left, -((int)right.getReal()), language), language);
                }
            } else {
                complexProfile.enter(inliningTarget);
                result = PowerNode.complexToComplexBoundary(left.getReal(), left.getImag(), right.getReal(), right.getImag(), language);
            }
            if (Double.isInfinite(result.getReal()) || Double.isInfinite(result.getImag())) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.COMPLEX_EXPONENTIATION);
            }
            return result;
        }

        @Specialization(guards={"!isPNone(mod)"})
        @HostCompilerDirectives.InliningCutoff
        static Object error(Object left, Object right, Object mod, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.COMPLEX_MODULO);
        }

        private static PComplex complexToSmallPositiveIntPower(ComplexValue x, long n, PythonLanguage language) {
            ComplexValue r = new ComplexValue(1.0, 0.0);
            ComplexValue p = x;
            for (long mask = 1L; mask > 0L && n >= mask; mask <<= 1) {
                if ((n & mask) != 0L) {
                    r = MulNode.multiply(r, p);
                }
                p = MulNode.multiply(p, p);
            }
            return PFactory.createComplex(language, r.getReal(), r.getImag());
        }

        @CompilerDirectives.TruffleBoundary
        private static PComplex complexToComplexBoundary(double leftRead, double leftImag, double rightReal, double rightImag, PythonLanguage language) {
            double vabs = Math.hypot(leftRead, leftImag);
            double len = Math.pow(vabs, rightReal);
            double at = Math.atan2(leftImag, leftRead);
            double phase = at * rightReal;
            if (rightImag != 0.0) {
                len /= Math.exp(at * rightImag);
                phase += rightImag * Math.log(vabs);
            }
            PComplex result = PFactory.createComplex(language, len * Math.cos(phase), len * Math.sin(phase));
            return result;
        }
    }

    @Slot(value=Slot.SlotKind.nb_subtract, isComplex=true)
    @GenerateNodeFactory
    static abstract class SubNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        SubNode() {
        }

        static PComplex doComplex(PComplex left, double right, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, left.getReal() - right, left.getImag());
        }

        @Specialization
        static PComplex doComplex(PComplex left, int right, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, left.getReal() - (double)right, left.getImag());
        }

        @Specialization
        static Object doComplex(Object leftObj, Object rightObj, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Bind PythonLanguage language) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return PFactory.createComplex(language, left.getReal() - right.getReal(), left.getImag() - right.getImag());
        }
    }

    @Slot(value=Slot.SlotKind.nb_multiply, isComplex=true)
    @GenerateNodeFactory
    static abstract class MulNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        MulNode() {
        }

        @Specialization
        static Object doComplex(Object leftObj, Object rightObj, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Bind PythonLanguage language) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            ComplexValue res = MulNode.multiply(left, right);
            return PFactory.createComplex(language, res.getReal(), res.getImag());
        }

        static ComplexValue multiply(ComplexValue left, ComplexValue right) {
            double newReal = left.getReal() * right.getReal() - left.getImag() * right.getImag();
            double newImag = left.getReal() * right.getImag() + left.getImag() * right.getReal();
            return new ComplexValue(newReal, newImag);
        }
    }

    @Slot(value=Slot.SlotKind.nb_true_divide, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DivNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        public abstract PComplex executeComplex(VirtualFrame var1, Object var2, Object var3);

        @NeverDefault
        public static DivNode create() {
            return ComplexBuiltinsFactory.DivNodeFactory.create();
        }

        @Specialization
        static Object doComplex(Object leftObj, Object rightObj, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Cached InlinedConditionProfile topConditionProfile, @Cached InlinedConditionProfile zeroDivisionProfile, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            double imag;
            double real;
            double absRightImag;
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            double absRightReal = right.getReal() < 0.0 ? -right.getReal() : right.getReal();
            if (topConditionProfile.profile(inliningTarget, absRightReal >= (absRightImag = right.getImag() < 0.0 ? -right.getImag() : right.getImag()))) {
                if (zeroDivisionProfile.profile(inliningTarget, absRightReal == 0.0)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_BY_ZERO, "complex");
                }
                double ratio = right.getImag() / right.getReal();
                double denom = right.getReal() + right.getImag() * ratio;
                real = (left.getReal() + left.getImag() * ratio) / denom;
                imag = (left.getImag() - left.getReal() * ratio) / denom;
            } else {
                double ratio = right.getReal() / right.getImag();
                double denom = right.getReal() * ratio + right.getImag();
                real = (left.getReal() * ratio + left.getImag()) / denom;
                imag = (left.getImag() * ratio - left.getReal()) / denom;
            }
            return PFactory.createComplex(language, real, imag);
        }

        static PComplex doubleDivComplex(double left, PComplex right, PythonLanguage language) {
            double oprealSq = right.getReal() * right.getReal();
            double opimagSq = right.getImag() * right.getImag();
            double realPart = right.getReal() * left;
            double imagPart = right.getImag() * left;
            double denom = oprealSq + opimagSq;
            return PFactory.createComplex(language, realPart / denom, -imagPart / denom);
        }
    }

    @Slot(value=Slot.SlotKind.nb_add, isComplex=true)
    @GenerateNodeFactory
    static abstract class AddNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        AddNode() {
        }

        @Specialization
        static PComplex doInt(PComplex left, int right, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, left.getReal() + (double)right, left.getImag());
        }

        @Specialization
        static PComplex doDouble(PComplex left, double right, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, left.getReal() + right, left.getImag());
        }

        @Specialization
        static Object doGeneric(Object leftObj, Object rightObj, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Bind PythonLanguage language) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return PFactory.createComplex(language, left.getReal() + right.getReal(), left.getImag() + right.getImag());
        }
    }

    @Slot(value=Slot.SlotKind.nb_absolute, isComplex=true)
    @GenerateNodeFactory
    public static abstract class AbsNode
    extends PythonUnaryBuiltinNode {
        private static final long MASK_NON_SIGN_LONG = Long.MAX_VALUE;

        public abstract double executeDouble(Object var1);

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static double abs(Object self, @Bind Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PRaiseNode raiseNode) {
            double scaledY;
            int expY;
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            double x = c.getReal();
            double y = c.getImag();
            if (Double.isInfinite(x) || Double.isInfinite(y)) {
                return Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(x) || Double.isNaN(y)) {
                return Double.NaN;
            }
            int expX = AbsNode.getExponent(x);
            if (expX > (expY = AbsNode.getExponent(y)) + 27) {
                return AbsNode.abs(x);
            }
            if (expY > expX + 27) {
                return AbsNode.abs(y);
            }
            int middleExp = (expX + expY) / 2;
            double scaledX = AbsNode.scalb(x, -middleExp);
            double scaledH = Math.sqrt(scaledX * scaledX + (scaledY = AbsNode.scalb(y, -middleExp)) * scaledY);
            double r = AbsNode.scalb(scaledH, middleExp);
            if (Double.isInfinite(r)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.ABSOLUTE_VALUE_TOO_LARGE);
            }
            return r;
        }

        static double abs(double x) {
            return Double.longBitsToDouble(Long.MAX_VALUE & Double.doubleToRawLongBits(x));
        }

        static double scalb(double d, int n) {
            if (n > -1023 && n < 1024) {
                return d * Double.longBitsToDouble((long)(n + 1023) << 52);
            }
            if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
                return d;
            }
            if (n < -2098) {
                return d > 0.0 ? 0.0 : -0.0;
            }
            if (n > 2097) {
                return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            long bits = Double.doubleToRawLongBits(d);
            long sign = bits & Long.MIN_VALUE;
            int exponent = (int)(bits >>> 52) & 0x7FF;
            long mantissa = bits & 0xFFFFFFFFFFFFFL;
            int scaledExponent = exponent + n;
            if (n < 0) {
                if (scaledExponent > 0) {
                    return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
                }
                if (scaledExponent > -53) {
                    long mostSignificantLostBit = (mantissa |= 0x10000000000000L) & 1L << -scaledExponent;
                    mantissa >>>= 1 - scaledExponent;
                    if (mostSignificantLostBit != 0L) {
                        ++mantissa;
                    }
                    return Double.longBitsToDouble(sign | mantissa);
                }
                return sign == 0L ? 0.0 : -0.0;
            }
            if (exponent == 0) {
                while (mantissa >>> 52 != 1L) {
                    mantissa <<= 1;
                    --scaledExponent;
                }
                mantissa &= 0xFFFFFFFFFFFFFL;
                if (++scaledExponent < 2047) {
                    return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
                }
                return sign == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (scaledExponent < 2047) {
                return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
            }
            return sign == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }

        static int getExponent(double d) {
            return (int)(Double.doubleToRawLongBits(d) >>> 52 & 0x7FFL) - 1023;
        }

        @NeverDefault
        public static AbsNode create() {
            return ComplexBuiltinsFactory.AbsNodeFactory.create();
        }
    }

    @Builtin(name="__complex__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ComplexNode
    extends PythonUnaryBuiltinNode {
        ComplexNode() {
        }

        @Specialization
        static Object complex(Object self, @Bind Node inliningTarget, @Cached PyComplexCheckExactNode check, @Cached ToComplexValueNode toComplexValueNode) {
            if (check.execute(inliningTarget, self)) {
                return self;
            }
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return PFactory.createComplex(PythonLanguage.get(inliningTarget), c.real, c.imag);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="complex", minNumOfPositionalArgs=1, parameterNames={"$cls", "real", "imag"})
    @GenerateNodeFactory
    public static abstract class ComplexNewNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private PyObjectReprAsObjectNode reprNode;
        @Node.Child
        private LookupAndCallUnaryNode callComplexNode;
        @Node.Child
        private WarningsModuleBuiltins.WarnNode warnNode;

        @Specialization(guards={"isNoValue(real)", "isNoValue(imag)"})
        static Object complexFromNone(Object cls, PNone real, PNone imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, 0.0, 0.0);
        }

        @Specialization
        static Object complexFromIntInt(Object cls, int real, int imaginary, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, real, imaginary);
        }

        @Specialization
        static Object complexFromLongLong(Object cls, long real, long imaginary, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, real, imaginary);
        }

        @Specialization
        static Object complexFromLongLong(Object cls, PInt real, PInt imaginary, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, real.doubleValueWithOverflow(inliningTarget), imaginary.doubleValueWithOverflow(inliningTarget));
        }

        @Specialization
        static Object complexFromDoubleDouble(Object cls, double real, double imaginary, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, real, imaginary);
        }

        @Specialization(guards={"isNoValue(imag)"})
        static Object complexFromDouble(Object cls, double real, PNone imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, real, 0.0);
        }

        @Specialization(guards={"isNoValue(real)"})
        static Object complexFromDoubleImag(Object cls, PNone real, double imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, 0.0, imag);
        }

        @Specialization(guards={"isNoValue(imag)"})
        Object complexFromDouble(VirtualFrame frame, Object cls, PFloat real, PNone imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode isBuiltinObjectProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return this.complexFromObject(frame, cls, real, imag, inliningTarget, createComplexNode, canBeDoubleNode, asDoubleNode, isComplexType, isResultComplexType, isPrimitiveProfile, isBuiltinObjectProfile, raiseNode);
        }

        @Specialization(guards={"isNoValue(real)"})
        Object complexFromDouble(VirtualFrame frame, Object cls, PNone real, PFloat imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode isBuiltinObjectProfile, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return this.complexFromObject(frame, cls, real, imag, inliningTarget, createComplexNode, canBeDoubleNode, asDoubleNode, isComplexType, isResultComplexType, isPrimitiveProfile, isBuiltinObjectProfile, raiseNode);
        }

        @Specialization(guards={"isNoValue(imag)"})
        static Object complexFromInt(Object cls, int real, PNone imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, real, 0.0);
        }

        @Specialization(guards={"isNoValue(real)"})
        static Object complexFromIntImag(Object cls, PNone real, int imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, 0.0, imag);
        }

        @Specialization(guards={"isNoValue(imag)"})
        static Object complexFromLong(Object cls, long real, PNone imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, real, 0.0);
        }

        @Specialization(guards={"isNoValue(real)"})
        static Object complexFromLongImag(Object cls, PNone real, long imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, 0.0, imag);
        }

        @Specialization(guards={"isNoValue(imag)"})
        Object complexFromLong(VirtualFrame frame, Object cls, PInt real, PNone imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode complexCheck, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return this.complexFromObject(frame, cls, real, imag, inliningTarget, createComplexNode, canBeDoubleNode, asDoubleNode, isComplexType, isResultComplexType, isPrimitiveProfile, complexCheck, raiseNode);
        }

        @Specialization(guards={"isNoValue(real)"})
        Object complexFromLong(VirtualFrame frame, Object cls, PNone real, PInt imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode complexCheck, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return this.complexFromObject(frame, cls, real, imag, inliningTarget, createComplexNode, canBeDoubleNode, asDoubleNode, isComplexType, isResultComplexType, isPrimitiveProfile, complexCheck, raiseNode);
        }

        @Specialization(guards={"isNoValue(imag)", "!isNoValue(number)", "!isString(number)"})
        Object complexFromObject(VirtualFrame frame, Object cls, Object number, PNone imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode complexCheck, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, number, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, number)) {
                    return createComplexNode.execute(inliningTarget, cls, asDoubleNode.execute(frame, inliningTarget, number), 0.0);
                }
                throw ComplexNewNode.raiseFirstArgError(number, inliningTarget, raiseNode);
            }
            if (isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PComplex)) {
                if (complexCheck.execute(inliningTarget, value)) {
                    return value;
                }
                return PFactory.createComplex(PythonLanguage.get(inliningTarget), value.getReal(), value.getImag());
            }
            return createComplexNode.execute(inliningTarget, cls, value.getReal(), value.getImag());
        }

        @Specialization(guards={"!isNoValue(imag)", "isNoValue(number)"})
        Object complexFromObject(VirtualFrame frame, Object cls, PNone number, Object imag, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode complexCheck, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, imag, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, imag)) {
                    return createComplexNode.execute(inliningTarget, cls, 0.0, asDoubleNode.execute(frame, inliningTarget, imag));
                }
                throw ComplexNewNode.raiseSecondArgError(imag, inliningTarget, raiseNode);
            }
            if (isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PComplex)) {
                return PFactory.createComplex(PythonLanguage.get(inliningTarget), -value.getImag(), 0.0);
            }
            return createComplexNode.execute(inliningTarget, cls, -value.getImag(), 0.0);
        }

        @Specialization
        static Object complexFromLongComplex(Object cls, long one, PComplex two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, (double)one - two.getImag(), two.getReal());
        }

        @Specialization
        static Object complexFromPIntComplex(Object cls, PInt one, PComplex two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, one.doubleValueWithOverflow(inliningTarget) - two.getImag(), two.getReal());
        }

        @Specialization
        static Object complexFromDoubleComplex(Object cls, double one, PComplex two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode) {
            return createComplexNode.execute(inliningTarget, cls, one - two.getImag(), two.getReal());
        }

        @Specialization(guards={"!isString(one)", "!isNoValue(one)"})
        Object complexFromComplexLong(VirtualFrame frame, Object cls, Object one, long two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return createComplexNode.execute(inliningTarget, cls, asDoubleNode.execute(frame, inliningTarget, one), two);
                }
                throw ComplexNewNode.raiseFirstArgError(one, inliningTarget, raiseNode);
            }
            return createComplexNode.execute(inliningTarget, cls, value.getReal(), value.getImag() + (double)two);
        }

        @Specialization(guards={"!isString(one)", "!isNoValue(one)"})
        Object complexFromComplexDouble(VirtualFrame frame, Object cls, Object one, double two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return createComplexNode.execute(inliningTarget, cls, asDoubleNode.execute(frame, inliningTarget, one), two);
                }
                throw ComplexNewNode.raiseFirstArgError(one, inliningTarget, raiseNode);
            }
            return createComplexNode.execute(inliningTarget, cls, value.getReal(), value.getImag() + two);
        }

        @Specialization(guards={"!isString(one)", "!isNoValue(one)"})
        Object complexFromComplexPInt(VirtualFrame frame, Object cls, Object one, PInt two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return createComplexNode.execute(inliningTarget, cls, asDoubleNode.execute(frame, inliningTarget, one), two.doubleValueWithOverflow(this));
                }
                throw ComplexNewNode.raiseFirstArgError(one, inliningTarget, raiseNode);
            }
            return createComplexNode.execute(inliningTarget, cls, value.getReal(), value.getImag() + two.doubleValueWithOverflow(this));
        }

        @Specialization(guards={"!isString(one)", "!isNoValue(one)"})
        Object complexFromComplexComplex(VirtualFrame frame, Object cls, Object one, PComplex two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return createComplexNode.execute(inliningTarget, cls, asDoubleNode.execute(frame, inliningTarget, one) - two.getImag(), two.getReal());
                }
                throw ComplexNewNode.raiseFirstArgError(one, inliningTarget, raiseNode);
            }
            return createComplexNode.execute(inliningTarget, cls, value.getReal() - two.getImag(), value.getImag() + two.getReal());
        }

        @Specialization(guards={"isString(two)"})
        Object secondArgString(VirtualFrame frame, Object cls, Object one, Object two, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.COMPLEX_SECOND_ARG_CANT_BE_STRING);
        }

        @Specialization(guards={"!isString(one)", "!isNoValue(two)", "!isPComplex(two)", "!isString(two)"})
        Object complexFromComplexObject(VirtualFrame frame, Object cls, Object one, Object two, @Bind Node inliningTarget, @Cached.Shared @Cached CreateComplexNode createComplexNode, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared @Cached PRaiseNode raiseNode) {
            PComplex oneValue = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (canBeDoubleNode.execute(inliningTarget, two)) {
                double twoValue = asDoubleNode.execute(frame, inliningTarget, two);
                if (oneValue == null) {
                    if (one == PNone.NO_VALUE) {
                        return createComplexNode.execute(inliningTarget, cls, 0.0, twoValue);
                    }
                    if (canBeDoubleNode.execute(inliningTarget, one)) {
                        return createComplexNode.execute(inliningTarget, cls, asDoubleNode.execute(frame, inliningTarget, one), twoValue);
                    }
                    throw ComplexNewNode.raiseFirstArgError(one, inliningTarget, raiseNode);
                }
                return createComplexNode.execute(inliningTarget, cls, oneValue.getReal(), oneValue.getImag() + twoValue);
            }
            throw ComplexNewNode.raiseSecondArgError(two, inliningTarget, raiseNode);
        }

        @Specialization
        Object complexFromString(VirtualFrame frame, Object cls, TruffleString real, Object imaginary, @Bind Node inliningTarget, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (imaginary != PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.COMPLEX_CANT_TAKE_ARG);
            }
            return this.convertStringToComplex(frame, inliningTarget, toJavaStringNode.execute((AbstractTruffleString)real), cls, real, raiseNode);
        }

        @Specialization
        Object complexFromString(VirtualFrame frame, Object cls, PString real, Object imaginary, @Bind Node inliningTarget, @Cached CastToJavaStringNode castToStringNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (imaginary != PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.COMPLEX_CANT_TAKE_ARG);
            }
            return this.convertStringToComplex(frame, inliningTarget, castToStringNode.execute(real), cls, real, raiseNode);
        }

        private Object callComplex(VirtualFrame frame, Object object) {
            if (this.callComplexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callComplexNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodNames.T___COMPLEX__));
            }
            return this.callComplexNode.executeObject(frame, object);
        }

        private WarningsModuleBuiltins.WarnNode getWarnNode() {
            if (this.warnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.warnNode = (WarningsModuleBuiltins.WarnNode)this.insert(WarningsModuleBuiltins.WarnNode.create());
            }
            return this.warnNode;
        }

        private static PException raiseFirstArgError(Object x, Node inliningTarget, PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_STRING_OR_NUMBER, "complex() first", x);
        }

        private static PException raiseSecondArgError(Object x, Node inliningTarget, PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_NUMBER, "complex() second", x);
        }

        private PComplex getComplexNumberFromObject(VirtualFrame frame, Object object, Node inliningTarget, PyComplexCheckExactNode isComplexType, PyComplexCheckExactNode isResultComplexType, PRaiseNode raiseNode) {
            if (isComplexType.execute(inliningTarget, object)) {
                return (PComplex)object;
            }
            Object result = this.callComplex(frame, object);
            if (result instanceof PComplex) {
                if (!isResultComplexType.execute(inliningTarget, result)) {
                    this.getWarnNode().warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, object, "__complex__", "complex", result, "complex");
                }
                return (PComplex)result;
            }
            if (result != PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.COMPLEX_RETURNED_NON_COMPLEX, result);
            }
            if (object instanceof PComplex) {
                return (PComplex)object;
            }
            return null;
        }

        @Fallback
        static Object complexGeneric(Object cls, Object realObj, Object imaginaryObj, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "complex.__new__(X): X", cls);
        }

        private Object convertStringToComplex(VirtualFrame frame, Node inliningTarget, String src, Object cls, Object origObj, PRaiseNode raiseNode) {
            String str = FloatUtils.removeUnicodeAndUnderscores(src);
            if (str == null) {
                Object strStr;
                if (this.reprNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.reprNode = (PyObjectReprAsObjectNode)this.insert(PyObjectReprAsObjectNode.create());
                }
                if (PGuards.isString(strStr = this.reprNode.executeCached((Frame)frame, origObj))) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.COULD_NOT_CONVERT_STRING_TO_COMPLEX, strStr);
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError);
            }
            Object c = this.convertStringToComplexOrNull(str, cls);
            if (c == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.COMPLEX_ARG_IS_MALFORMED_STR);
            }
            return c;
        }

        @CompilerDirectives.TruffleBoundary
        private Object convertStringToComplexOrNull(String str, Object cls) {
            boolean expectJ;
            double y;
            double x;
            char ch;
            boolean gotBracket;
            int len = str.length();
            int i = FloatUtils.skipAsciiWhitespace(str, 0, len);
            if (i < len && str.charAt(i) == '(') {
                gotBracket = true;
                i = FloatUtils.skipAsciiWhitespace(str, i + 1, len);
            } else {
                gotBracket = false;
            }
            FloatUtils.StringToDoubleResult res1 = FloatUtils.stringToDouble(str, i, len);
            if (res1 != null) {
                i = res1.position;
                char c = ch = i < len ? str.charAt(i) : (char)'\u0000';
                if (ch == '+' || ch == '-') {
                    x = res1.value;
                    FloatUtils.StringToDoubleResult res2 = FloatUtils.stringToDouble(str, i, len);
                    if (res2 != null) {
                        y = res2.value;
                        i = res2.position;
                    } else {
                        y = ch == '+' ? 1.0 : -1.0;
                        ++i;
                    }
                    expectJ = true;
                } else if (ch == 'j' || ch == 'J') {
                    ++i;
                    y = res1.value;
                    x = 0.0;
                    expectJ = false;
                } else {
                    x = res1.value;
                    y = 0.0;
                    expectJ = false;
                }
            } else {
                char c = ch = i < len ? str.charAt(i) : (char)'\u0000';
                if (ch == '+' || ch == '-') {
                    y = ch == '+' ? 1.0 : -1.0;
                    ++i;
                } else {
                    y = 1.0;
                }
                x = 0.0;
                expectJ = true;
            }
            if (expectJ) {
                char c = ch = i < len ? str.charAt(i) : (char)'\u0000';
                if (ch != 'j' && ch != 'J') {
                    return null;
                }
                ++i;
            }
            i = FloatUtils.skipAsciiWhitespace(str, i, len);
            if (gotBracket) {
                if (i >= len || str.charAt(i) != ')') {
                    return null;
                }
                i = FloatUtils.skipAsciiWhitespace(str, i + 1, len);
            }
            if (i != len) {
                return null;
            }
            return CreateComplexNode.executeUncached(cls, x, y);
        }

        @GenerateInline
        @GenerateCached(value=false)
        @GenerateUncached
        static abstract class CreateComplexNode
        extends Node {
            CreateComplexNode() {
            }

            public abstract Object execute(Node var1, Object var2, double var3, double var5);

            public static Object executeUncached(Object cls, double real, double imaginary) {
                return ComplexBuiltinsFactory.ComplexNewNodeFactory.CreateComplexNodeGen.getUncached().execute(null, cls, real, imaginary);
            }

            @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)"}, limit="1")
            static PComplex doManaged(Node inliningTarget, Object cls, double real, double imaginary, @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
                return PFactory.createComplex(language, cls, getInstanceShape.execute(cls), real, imaginary);
            }

            @Fallback
            static Object doNative(Node inliningTarget, Object cls, double real, double imaginary, @Cached(inline=false) CExtNodes.PCallCapiFunction callCapiFunction, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached(inline=false) ExternalFunctionNodes.DefaultCheckFunctionResultNode checkFunctionResultNode) {
                NativeCAPISymbol symbol = NativeCAPISymbol.FUN_COMPLEX_SUBTYPE_FROM_DOUBLES;
                Object nativeResult = callCapiFunction.call(symbol, toNativeNode.execute(cls), real, imaginary);
                return toPythonNode.execute(checkFunctionResultNode.execute(PythonContext.get(inliningTarget), symbol.getTsName(), nativeResult));
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class ToComplexValueNode
    extends Node {
        ToComplexValueNode() {
        }

        public abstract ComplexValue execute(Node var1, Object var2);

        @Specialization
        static ComplexValue doComplex(PComplex v) {
            return new ComplexValue(v.getReal(), v.getImag());
        }

        @Specialization(guards={"check.execute(inliningTarget, v)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static ComplexValue doNative(Node inliningTarget, PythonAbstractNativeObject v, @Cached PyComplexCheckNode check, @Cached(inline=false) CStructAccess.ReadDoubleNode read) {
            double real = read.readFromObj(v, CFields.PyComplexObject__cval__real);
            double imag = read.readFromObj(v, CFields.PyComplexObject__cval__imag);
            return new ComplexValue(real, imag);
        }

        @Specialization
        static ComplexValue doInt(int v) {
            return new ComplexValue(v, 0.0);
        }

        @Specialization
        static ComplexValue doDouble(double v) {
            return new ComplexValue(v, 0.0);
        }

        @Specialization(guards={"check.execute(inliningTarget, v)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static ComplexValue doIntGeneric(Node inliningTarget, Object v, @Cached PyLongCheckNode check, @Cached PyLongAsDoubleNode longAsDoubleNode) {
            return new ComplexValue(longAsDoubleNode.execute(inliningTarget, v), 0.0);
        }

        @Specialization(guards={"check.execute(inliningTarget, v)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static ComplexValue doFloatGeneric(Node inliningTarget, Object v, @Cached PyFloatCheckNode check, @Cached PyFloatAsDoubleNode floatAsDoubleNode) {
            return new ComplexValue(floatAsDoubleNode.execute(null, inliningTarget, v), 0.0);
        }

        @Fallback
        static ComplexValue doOther(Node inliningTarget, Object v) {
            return null;
        }
    }

    @CompilerDirectives.ValueType
    static final class ComplexValue {
        private final double real;
        private final double imag;

        ComplexValue(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }

        public double getReal() {
            return this.real;
        }

        public double getImag() {
            return this.imag;
        }
    }
}

