/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntryKey;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class ResultSetCacheEntry {
    private final AtomicReference<QueryResultState> queryResultState;
    private int numRows;
    private ByteArray rowData;
    private AccessorPrototype[] accessorPrototypes;
    String userName;
    ResultSetCacheEntryKey key;
    long queryId;
    long sizeInMemory;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    ResultSetCacheEntry(ResultSetCacheEntryKey key, long queryId) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$11, null, key, queryId);
            }
            this.queryResultState = new AtomicReference<QueryResultState>(QueryResultState.FETCHING);
            this.numRows = -1;
            this.rowData = null;
            this.accessorPrototypes = null;
            if (!$assertionsDisabled && queryId == 0L) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$11, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.key = key;
            this.queryId = queryId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    ResultSetCacheEntryKey getResultSetCacheEntryKey() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$0, this, new Object[0]);
            }
            ResultSetCacheEntryKey resultSetCacheEntryKey = this.key;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$0, this, resultSetCacheEntryKey);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$0, this, null);
            }
            return resultSetCacheEntryKey;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initialize(int n2, ByteArray byteArray, Accessor[] accessorArray, long l2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sizeInMemory;
            void _accessors;
            void _rowData;
            void _numRows;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, n2, byteArray, accessorArray, l2);
            }
            if (!$assertionsDisabled && this.queryResultState.get() == QueryResultState.VALID) {
                AssertionError assertionError = new AssertionError((Object)("queryResultState: " + this.queryResultState));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && _numRows < 0) {
                AssertionError assertionError = new AssertionError((Object)("_numRows: " + (int)_numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && _rowData == null) {
                AssertionError assertionError = new AssertionError((Object)"null _rowData");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && _accessors == null) {
                AssertionError assertionError = new AssertionError((Object)"null _accessors");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (this.queryResultState.get() == QueryResultState.INVALID) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, null);
                }
                return;
            }
            this.numRows = _numRows;
            this.rowData = _rowData;
            this.accessorPrototypes = new AccessorPrototype[((void)_accessors).length];
            for (int i2 = 0; i2 < ((void)_accessors).length; ++i2) {
                if (!$assertionsDisabled && _accessors[i2] == null) {
                    AssertionError assertionError = new AssertionError((Object)("null _accessor: " + i2));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                this.accessorPrototypes[i2] = _accessors[i2].newPrototype(this.numRows);
            }
            this.sizeInMemory = sizeInMemory;
            this.queryResultState.compareAndSet(QueryResultState.FETCHING, QueryResultState.VALID);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isFetching() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.queryResultState.get() == QueryResultState.FETCHING;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$2, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isValid() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$3, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.queryResultState.get() == QueryResultState.VALID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$3, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isInvalid() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$4, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.queryResultState.get() == QueryResultState.INVALID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$4, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    void invalidate() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$5, this, new Object[0]);
            }
            this.queryResultState.set(QueryResultState.INVALID);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    int getNumberOfRows() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (!$assertionsDisabled && this.queryResultState.get() == QueryResultState.FETCHING) {
                AssertionError assertionError = new AssertionError((Object)("queryResultState: " + this.queryResultState));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$6, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = this.numRows;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    ByteArray getRowData() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (!$assertionsDisabled && this.queryResultState.get() == QueryResultState.FETCHING) {
                AssertionError assertionError = new AssertionError((Object)("queryResultState: " + this.queryResultState));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$7, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            ByteArray byteArray = this.rowData;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$7, this, byteArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$7, this, null);
            }
            return byteArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    long getQueryId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$8, this, new Object[0]);
            }
            long l2 = this.queryId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$8, this, l2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$8, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    long getSizeInMemory() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$9, this, new Object[0]);
            }
            long l2 = this.sizeInMemory;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$9, this, l2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$9, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Accessor[] newAccessors(OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$10, this, oracleStatement);
            }
            if (!$assertionsDisabled && this.queryResultState.get() == QueryResultState.FETCHING) {
                AssertionError assertionError = new AssertionError((Object)("queryResultState: " + this.queryResultState));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$10, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && stmt == null) {
                AssertionError assertionError = new AssertionError((Object)"null stmt");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$10, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            Accessor[] acc = new Accessor[this.accessorPrototypes.length];
            for (int i2 = 0; i2 < this.accessorPrototypes.length; ++i2) {
                acc[i2] = this.accessorPrototypes[i2].newAccessor((OracleStatement)stmt);
            }
            Accessor[] accessorArray = acc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$10, this, accessorArray);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$10, this, null);
            }
            return acc;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ResultSetCacheEntry.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = ResultSetCacheEntry.class.getDeclaredConstructor(ResultSetCacheEntryKey.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ResultSetCacheEntry.class.getDeclaredMethod("newAccessors", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ResultSetCacheEntry.class.getDeclaredMethod("getSizeInMemory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ResultSetCacheEntry.class.getDeclaredMethod("getQueryId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ResultSetCacheEntry.class.getDeclaredMethod("getRowData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ResultSetCacheEntry.class.getDeclaredMethod("getNumberOfRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ResultSetCacheEntry.class.getDeclaredMethod("invalidate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ResultSetCacheEntry.class.getDeclaredMethod("isInvalid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ResultSetCacheEntry.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ResultSetCacheEntry.class.getDeclaredMethod("isFetching", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ResultSetCacheEntry.class.getDeclaredMethod("initialize", Integer.TYPE, ByteArray.class, Accessor[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetCacheEntry.class.getDeclaredMethod("getResultSetCacheEntryKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static final class QueryResultState
    extends Enum<QueryResultState> {
        public static final /* enum */ QueryResultState FETCHING;
        public static final /* enum */ QueryResultState VALID;
        public static final /* enum */ QueryResultState INVALID;
        private static final /* synthetic */ QueryResultState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static QueryResultState[] values() {
            return (QueryResultState[])$VALUES.clone();
        }

        public static QueryResultState valueOf(String name) {
            return Enum.valueOf(QueryResultState.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = QueryResultState.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = QueryResultState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = QueryResultState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            FETCHING = new QueryResultState();
            VALID = new QueryResultState();
            INVALID = new QueryResultState();
            $VALUES = new QueryResultState[]{FETCHING, VALID, INVALID};
        }
    }
}

