/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXid
implements Xid,
Serializable {
    private int formatId;
    private byte[] gtrid;
    private byte[] bqual;
    private byte[] txctx;
    private int m_hashCode;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private int state;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public OracleXid(int fId, byte[] gId, byte[] bId) throws XAException {
        this(fId, gId, bId, null);
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleXid.class, $$$methodRef$$$11, null, fId, gId, bId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleXid.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXid.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXid.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleXid(int fId, byte[] gId, byte[] bId, byte[] context) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleXid.class, $$$methodRef$$$12, null, fId, gId, bId, context);
            }
            this.gtrid = null;
            this.bqual = null;
            this.txctx = null;
            this.m_hashCode = 0;
            this.formatId = fId;
            if (gId != null && gId.length > 64) {
                XAException xAException = (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleXid.class, $$$methodRef$$$12, null, xAException);
                }
                throw xAException;
            }
            this.gtrid = gId;
            if (bId != null && bId.length > 64) {
                XAException xAException = (XAException)DatabaseError.createXAException(-4).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleXid.class, $$$methodRef$$$12, null, xAException);
                }
                throw xAException;
            }
            this.bqual = bId;
            this.txctx = context;
            this.state = 0;
            this.m_hashCode = this.computeHashCode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleXid.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXid.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXid.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setState(int n2) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void k2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleXid.class, $$$methodRef$$$0, this, n2);
            }
            this.state = k2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleXid.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXid.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXid.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getState() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleXid.class, $$$methodRef$$$1, this, new Object[0]);
            }
            int n2 = this.state;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleXid.class, $$$methodRef$$$1, this, n2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXid.class, $$$methodRef$$$1, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXid.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getFormatId() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleXid.class, $$$methodRef$$$2, this, new Object[0]);
            }
            int n2 = this.formatId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleXid.class, $$$methodRef$$$2, this, n2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXid.class, $$$methodRef$$$2, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXid.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getGlobalTransactionId() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleXid.class, $$$methodRef$$$3, this, new Object[0]);
            }
            byte[] byArray = this.gtrid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleXid.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXid.class, $$$methodRef$$$3, this, null);
            }
            return this.gtrid;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXid.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] getBranchQualifier() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleXid.class, $$$methodRef$$$4, this, new Object[0]);
            }
            byte[] byArray = this.bqual;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleXid.class, $$$methodRef$$$4, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXid.class, $$$methodRef$$$4, this, null);
            }
            return this.bqual;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXid.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] getTxContext() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleXid.class, $$$methodRef$$$5, this, new Object[0]);
            }
            byte[] byArray = this.txctx;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleXid.class, $$$methodRef$$$5, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXid.class, $$$methodRef$$$5, this, null);
            }
            return this.txctx;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXid.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTxContext(byte[] byArray) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void context;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleXid.class, $$$methodRef$$$6, this, new Object[]{byArray});
            }
            this.txctx = context;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleXid.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXid.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXid.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public static final boolean isLocalTransaction(Xid xid) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Xid xid2;
            byte[] gtrid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, xid);
            }
            if ((gtrid = xid2.getGlobalTransactionId()) == null) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, bl2);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, null);
                }
                return true;
            }
            for (int i2 = 0; i2 < gtrid.length; ++i2) {
                if (gtrid[i2] == 0) continue;
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, bl3);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, null);
                }
                return false;
            }
            boolean bl4 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, bl4);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXid.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DefaultLevel(value=Logging.FINEST)
    public boolean equals(Object object) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            void xid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, object);
            }
            if (this == xid) {
                boolean bl3 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, null);
                }
                return true;
            }
            if (xid == null || !(xid instanceof Xid)) {
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, null);
                }
                return false;
            }
            Xid _xid = (Xid)xid;
            boolean bl5 = bl2 = this.getFormatId() == _xid.getFormatId() && Arrays.equals(this.getGlobalTransactionId(), _xid.getGlobalTransactionId()) && Arrays.equals(this.getBranchQualifier(), _xid.getBranchQualifier());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, null);
            }
            return bl5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXid.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public int hashCode() {
        return this.m_hashCode;
    }

    private int computeHashCode() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            int i2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleXid.class, $$$methodRef$$$9, this, new Object[0]);
            }
            int total = 0;
            byte[] xid1Gtrid = this.getGlobalTransactionId();
            byte[] xid1Bqual = this.getBranchQualifier();
            total += this.getFormatId();
            if (xid1Gtrid == null) {
                total += 0;
            } else {
                for (i2 = 0; i2 < xid1Gtrid.length; ++i2) {
                    total += xid1Gtrid[i2];
                }
            }
            if (xid1Bqual == null) {
                total += 0;
            } else {
                for (i2 = 0; i2 < xid1Bqual.length; ++i2) {
                    total += xid1Bqual[i2];
                }
            }
            int n2 = total;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleXid.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXid.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXid.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleXid.class, $$$methodRef$$$10, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleXid.class, $$$methodRef$$$10, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXid.class, $$$methodRef$$$10, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXid.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = OracleXid.class.getDeclaredConstructor(Integer.TYPE, byte[].class, byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXid.class.getDeclaredConstructor(Integer.TYPE, byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXid.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXid.class.getDeclaredMethod("computeHashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXid.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXid.class.getDeclaredMethod("isLocalTransaction", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXid.class.getDeclaredMethod("setTxContext", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXid.class.getDeclaredMethod("getTxContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXid.class.getDeclaredMethod("getBranchQualifier", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXid.class.getDeclaredMethod("getGlobalTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXid.class.getDeclaredMethod("getFormatId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXid.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXid.class.getDeclaredMethod("setState", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

