/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.asyncio.GetAwaitableNodeGen;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@OperationProxy.Proxyable
@GenerateInline(value=false)
public abstract class GetAwaitableNode
extends Node {
    public abstract Object execute(VirtualFrame var1, Object var2);

    @Specialization
    public static Object doGenerator(PGenerator generator, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raise, @Cached.Exclusive @Cached PRaiseNode raiseReusedCoro) {
        if (generator.isCoroutine()) {
            if (generator.getYieldFrom() != null) {
                throw raiseReusedCoro.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CORO_ALREADY_AWAITED);
            }
            return generator;
        }
        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_BE_USED_AWAIT, "generator");
    }

    @Fallback
    public static Object doGeneric(VirtualFrame frame, Object awaitable, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raiseNoAwait, @Cached.Exclusive @Cached PRaiseNode raiseNotIter, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callSlot, @Cached GetClassNode getAwaitableType, @Cached GetClassNode getIteratorType, @Cached PyIterCheckNode iterCheck) {
        Object type = getAwaitableType.execute(inliningTarget, awaitable);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.am_await() == null) {
            throw raiseNoAwait.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_BE_USED_AWAIT, type);
        }
        Object iterator = callSlot.execute(frame, inliningTarget, slots.am_await(), awaitable);
        if (iterCheck.execute(inliningTarget, iterator)) {
            return iterator;
        }
        Object itType = getIteratorType.execute(inliningTarget, iterator);
        if (itType == PythonBuiltinClassType.PCoroutine) {
            throw raiseNotIter.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.AWAIT_RETURN_COROUTINE);
        }
        throw raiseNotIter.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.AWAIT_RETURN_NON_ITER, itType);
    }

    @NeverDefault
    public static GetAwaitableNode create() {
        return GetAwaitableNodeGen.create();
    }

    public static GetAwaitableNode getUncached() {
        return GetAwaitableNodeGen.getUncached();
    }
}

