\name{BinaryErodeImageFilter}
\alias{BinaryErodeImageFilter}
\title{BinaryErodeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Fast binary erosion of a single intensity value in the image.
BinaryErodeImageFilter}
\details{
BinaryErodeImageFilter is a binary erosion morphologic operation on the foreground of an
image. Only the value designated by the intensity value
"SetForegroundValue()" (alias as SetErodeValue() ) is considered as
foreground, and other intensity values are considered background.
Grayscale images can be processed as binary images by selecting a
"ForegroundValue" (alias "ErodeValue"). Pixel values matching the
erode value are considered the "foreground" and all other pixels are
"background". This is useful in processing segmented images where
all pixels in segment #1 have value 1 and pixels in segment #2 have
value 2, etc. A particular "segment number" can be processed.
ForegroundValue defaults to the maximum possible value of the
PixelType. The eroded pixels will receive the BackgroundValue
(defaults to NumericTraits::NonpositiveMin() ).
The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel. A reasonable choice
of structuring element is itk::BinaryBallStructuringElement .
This implementation is based on the papers:
L.Vincent "Morphological transformations of binary images with
arbitrary structuring elements", and
N.Nikopoulos et al. "An efficient algorithm for 3d binary
morphological transformations with 3d structuring elements for
arbitrary size and shape". IEEE Transactions on Image Processing. Vol. 9. No. 3. 2000. pp. 283-286.
See:
ImageToImageFilter BinaryDilateImageFilter BinaryMorphologyImageFilter
BinaryErode for the procedural interface
itk::BinaryErodeImageFilter for the Doxygen on the original ITK class.
BinaryErodeImageFilter}
%C++ includes: sitkBinaryErodeImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryErodeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self BoundaryToForegroundOff():}{}
\item{Self BoundaryToForegroundOn():}{
Set the value of BoundaryToForeground to true or false respectfully.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{}
\item{bool GetBoundaryToForeground() const:}{}
\item{double GetForegroundValue() const:}{}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetBackgroundValue(double BackgroundValue):}{}
\item{Self SetBoundaryToForeground(bool BoundaryToForeground):}{}
\item{Self SetForegroundValue(double ForegroundValue):}{}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryErodeImageFilter():}{
Destructor
}
}
}
